//
//  ExerciseDetail.swift
//  PuppyTraining-final
//
//  Created by Natalia Panferova on 15/08/22.
//  Copyright © 2025 NIL COALESCING LIMITED. All rights reserved.
//

import SwiftUI

struct ExerciseDetail: View {
    let exercise: Exercise
    
    var body: some View {
        ScrollView {
            VStack(alignment: .leading, spacing: 30) {
                ExerciseDetailHeader(exercise: exercise)
                ExerciseSteps(steps: exercise.steps)
            }
            .padding()
            .frame(maxWidth: .infinity, alignment: .leading)
        }
    }
}

#Preview {
    let exercise = ExercisesController().exercises[0]
    
    NavigationStack {
        ExerciseDetail(exercise: exercise)
            .navigationTitle(exercise.title)
            .navigationBarTitleDisplayMode(.inline)
    }
}
